/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.model.BaseElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementElement
extends BaseElement {
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String REMARK_PROPERTY = "remark";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private String _displayName;
    private List<String> _properties;
    private String _remark;

    public void addProperty(String name) {
        if (!StringUtil.isEmpty((String)name)) {
            if (this._properties == null) {
                this._properties = new ArrayList<String>();
            }
            this._properties.add(name);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setDisplayName(StringUtil.getStringValue(object.get(DISPLAY_NAME_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this._properties = IndexUtil.createList(object.get(PROPERTIES_PROPERTY));
    }

    public String getDisplayName() {
        return StringUtil.getStringValue((Object)this._displayName);
    }

    public List<String> getProperties() {
        return CollectionsUtil.getListValue(this._properties);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(DISPLAY_NAME_PROPERTY, (Object)this.getDisplayName());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(PROPERTIES_PROPERTY, this.getProperties());
    }
}

